/*
BajaScript can be used to query a Station via SQL, BQL etc...

- For more information, please see the JsDocs for baja.coll.Table and baja.coll.Collection
*/

// Run the BQL query in the Station and print out the results...
baja.Ord.make("station:|slot:/|bql:select toPathString from baja:Component").get({
  ok: function (result) {
    // Iterate through all of the Columns
    baja.iterate(result.getColumns(), function (c) {
      baja.outln("Column display name: " + c.getDisplayName());
    });
  },
  cursor: {
    before: function () {
      baja.outln("Called just before iterating through the Cursor");
    },
    after: function () {
      baja.outln("Called just after iterating through the Cursor");
    },
    each: function () {
      baja.outln(this.get("toPathString"));
    },
    limit: 15, // Specify optional limit on the number of records (defaults to 10)
    offset: 0 // Specify optional record offset (defaults to 0)
  }
});

// Why not try changing the above code just for fun? If you get stuck just refresh the browser.
